/*
 * Decompiled with CFR 0.152.
 */
package net.voidz.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.voidz.dimension.VoidPlacementHandler;
import net.voidz.init.BlockInit;
import net.voidz.init.ConfigInit;
import net.voidz.init.DimensionInit;

public class PortalBlockEntity
extends BlockEntity {
    private float particleTicker;
    private int spawnTicker;
    public int bossTime;

    public PortalBlockEntity(BlockPos pos, BlockState state) {
        super(BlockInit.PORTAL_BLOCK_ENTITY, pos, state);
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, PortalBlockEntity blockEntity) {
        blockEntity.update();
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, PortalBlockEntity blockEntity) {
        blockEntity.update();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.bossTime = nbt.m_128451_("VoidShadowKilledTime");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("VoidShadowKilledTime", this.bossTime);
    }

    private void update() {
        if (this.f_58857_.m_5776_()) {
            this.particleTicker += 0.024543693f;
            double angle = Math.PI * 2 * (double)this.particleTicker;
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)this.m_58899_().m_123341_() + 0.5 + 1.5 * Math.sin(angle), (double)this.m_58899_().m_123342_() + 0.5 + Math.sin(angle) / 2.0, (double)this.m_58899_().m_123343_() + 0.5 + 1.5 * Math.cos(angle), 0.0, 0.0, 0.0);
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)this.m_58899_().m_123341_() + 0.5 + 1.5 * Math.sin(angle), (double)this.m_58899_().m_123342_() + 0.5 + Math.sin(angle + Math.PI) / 2.0, (double)this.m_58899_().m_123343_() + 0.5 + 1.5 * Math.cos(angle), 0.0, 0.0, 0.0);
        } else {
            ++this.spawnTicker;
            if (this.spawnTicker % 100 == 0 && this != null && ConfigInit.CONFIG.allow_boss_respawn && this.bossTime != 0 && this.f_58857_.m_46472_() == DimensionInit.VOID_WORLD && (int)this.f_58857_.m_6106_().m_6793_() > this.bossTime + ConfigInit.CONFIG.boss_respawn_time) {
                ((ServerLevel)this.f_58857_).m_6263_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), SoundEvents.f_12563_, SoundSource.HOSTILE, 2.0f, 1.0f);
                this.bossTime = 0;
                VoidPlacementHandler.spawnVoidBoss((ServerLevel)this.f_58857_, this.f_58858_.m_7494_());
            }
        }
    }
}

